DROP PROCEDURE [hips].[DocumentFormatGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Credte ddte: 11 Jun 2013
-- Description:   Gets a specific record or all records from the DocumentFormat table.
-- =============================================
CREatE PROCEDURE [hips].[DocumentFormatGet] 
(
	@DocumentFormatId INT = null
)
AS
BEGIN
SELECT  df.DocumentFormatId,
		df.Code,
		df.Description,
		df.CodeSystemId,
		cs.Code CodeSystemCode,
		cs.Description CodeSystemDescription,
		df.DateCreated,
		df.UserCreated,
		df.DateModified,
		df.UserModified		
FROM  hips.DocumentFormat df
INNER JOIN hips.CodeSystem cs ON cs.CodeSystemId = df.CodeSystemId
WHERE (df.DocumentFormatId = @DocumentFormatId OR @DocumentFormatId IS NULL)
ORDER BY df.Code asc
END
GO

